#ifndef RWCOMMON_H
#define RWCOMMON_H

#include "rwcore.h"
#include "rpworld.h"
#include "rpanim.h"

typedef MObject (*MayaObjectCallBack)(MObject object, void *pData);

bool        OpenRenderWare(HWND window, bool openRpAnim, bool openRpSkin,
                      bool openRpHAnim, bool openCollision, bool openMorph,
                      bool openSpline, bool openMipKL, bool openUserData);
bool        CloseRenderWare(void);

/* Material Color functions */
RpMaterial      *CheckMaterialColors(RpMaterial *material, void *pData);
bool            GeometryHasColoredMaterials(RpGeometry *geometry);
bool            WorldHasColoredMaterials(RpWorld *world);

/* Material FX functions */
bool            GeometryHasMaterialFX(RpGeometry *geometry);
RpWorldSector   *WorldSectorHasMaterialFX(RpWorldSector *sector, void *pData __RWUNUSED__);

/* General Functions */
void    forAllNodesInScene(MFn::Type fnType, MayaObjectCallBack callBack, void *pData);
void    OffsetTextureCoords(RwV3d *uv, int uvCount);

#endif /* RWCOMMON_H */